#!/usr/bin/python
#
# Generational Ages Report Script
# 17 JAN 2011, by John A. Nairn
#	
# This script generates a report of average ages of all spouses when
# they got married and when their children were born.
#	
# The report can be for all spouses in the file or just for spouses
# in the currently selected family records.

# Load GEDitCOM II Module
from GEDitCOMII import *
from PyAgeModule import *
    
# Preamble
gedit = CheckVersionAndDocument("Generation Ages to Report (Python)",1.6,2)
if not(gedit) : quit()
gdoc = FrontDocument()

# choose all or currently selected family records
whichOnes = GetOption("Get report for All or just Selected family records",\
None,["All", "Cancel", "Selected"])
if whichOnes=="Cancel":quit()

# Get of list of the choosen family records
if whichOnes=="All":
    fams = gdoc.families()
else:
    fams = GetSelectedType("FAM")

# No report if no family records were found
if len(fams)==0:
    Alert("No family records were selected")
    quit()

# Collect all report data in a subroutine
CollectAges(fams)

# write to report and then done
WriteToReport(GetScriptName(),gdoc.name())


